/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Random;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.characterviewer.ItemViewerUI;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;
import technology.rocketjump.undermount.guice.UndermountGuiceModule;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.rendering.entities.EntityRenderer;

public class ItemViewerApplication
extends ApplicationAdapter {
    private SpriteBatch batch;
    private ShapeRenderer shapeRenderer;
    private EntityRenderer entityRenderer;
    private ItemEntityFactory entityFactory;
    private PrimaryCameraWrapper cameraManager;
    private ItemTypeDictionary itemTypeDictionary;
    private GameMaterialDictionary gameMaterialDictionary;
    private PlantSpeciesDictionary plantSpeciesDictionary;
    private ItemViewerUI ui;
    private Entity currentEntity;
    private ItemEntityAttributes attributes;
    private GameMaterial backgroundMaterial;
    private GameMaterial mainMaterial;
    private GameMaterial highlightMaterial;
    private DebugWindow debugWindow;
    private GridPoint2 tilePostion;
    private EntityAssetUpdater entityAssetUpdater;

    @Override
    public void create() {
        Injector injector = Guice.createInjector(new UndermountGuiceModule());
        this.entityRenderer = injector.getInstance(EntityRenderer.class);
        this.entityFactory = injector.getInstance(ItemEntityFactory.class);
        this.cameraManager = injector.getInstance(PrimaryCameraWrapper.class);
        this.debugWindow = injector.getInstance(DebugWindow.class);
        this.itemTypeDictionary = injector.getInstance(ItemTypeDictionary.class);
        this.entityAssetUpdater = injector.getInstance(EntityAssetUpdater.class);
        this.gameMaterialDictionary = injector.getInstance(GameMaterialDictionary.class);
        this.plantSpeciesDictionary = injector.getInstance(PlantSpeciesDictionary.class);
        this.debugWindow.offsetPosition.x = 250.0f;
        this.batch = new SpriteBatch();
        this.shapeRenderer = new ShapeRenderer();
        Random random = new Random();
        this.attributes = new ItemEntityAttributes(0L);
        this.attributes.setQuantity(1);
        this.attributes.setItemType(this.itemTypeDictionary.getByName("Tool-Tongs"));
        this.attributes.setMaterial(this.gameMaterialDictionary.getByName("Dolostone"));
        this.attributes.setMaterial(this.gameMaterialDictionary.getByName("Hematite"));
        this.attributes.setMaterial(this.gameMaterialDictionary.getByName("Ruby"));
        GameMaterial testMetal = new GameMaterial("Test metal material", -1L, GameMaterialType.METAL, "#DDDDDE", null, null, null, true);
        this.attributes.setMaterial(testMetal);
        this.attributes.setColor(ColoringLayer.METAL_COLOR, new Color(0.7f, 0.7f, 0.8f, 1.0f));
        PlantSpecies plantSpecies = this.plantSpeciesDictionary.getByName("Birch");
        this.attributes.setMaterial(plantSpecies.getBranchMaterial());
        this.attributes.setColor(ColoringLayer.BRANCHES_COLOR, plantSpecies.randomBranchColor(random));
        Vector2 position = new Vector2(this.cameraManager.getCamera().viewportWidth * 0.75f, this.cameraManager.getCamera().viewportHeight * 0.2f);
        this.tilePostion = new GridPoint2((int)Math.floor(position.x), (int)Math.floor(position.y));
        this.currentEntity = this.entityFactory.create(this.attributes, this.tilePostion, null);
        this.entityAssetUpdater.updateEntityAssets(this.currentEntity);
        this.ui = injector.getInstance(ItemViewerUI.class);
        this.ui.init(this.currentEntity);
        Gdx.input.setInputProcessor(this.ui.getStage());
    }

    @Override
    public void render() {
        this.renderBackground();
        this.batch.begin();
        this.batch.setProjectionMatrix(this.cameraManager.getCamera().combined);
        Vector2 originalPosition = this.currentEntity.getLocationComponent().getWorldPosition().cpy();
        this.attributes.setItemPlacement(ItemPlacement.BEING_CARRIED);
        this.entityAssetUpdater.updateEntityAssets(this.currentEntity);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 0.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_RIGHT.toVector2(), 1.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_LEFT.toVector2(), -1.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP.toVector2(), 0.0f, 2.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_RIGHT.toVector2(), 1.0f, 2.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_LEFT.toVector2(), -1.0f, 2.0f, RenderMode.DIFFUSE);
        this.attributes.setItemPlacement(ItemPlacement.ON_GROUND);
        this.entityAssetUpdater.updateEntityAssets(this.currentEntity);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 0.0f, 0.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 1.0f, 0.0f, RenderMode.NORMALS);
        this.batch.end();
        this.shapeRenderer.setProjectionMatrix(this.cameraManager.getCamera().combined);
        this.shapeRenderer.setColor(Color.BLUE);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.end();
        this.ui.render();
        this.debugWindow.render();
    }

    private void renderEntityWithOrientation(Vector2 originalPosition, Vector2 orientation, float offsetX, float offsetY, RenderMode renderMode) {
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(orientation), true);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(offsetX, offsetY), false);
        this.entityRenderer.render(this.currentEntity, (Batch)this.batch, renderMode, null, null);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition, false);
    }

    private void renderBackground() {
        Gdx.gl.glClearColor(0.6f, 0.6f, 0.6f, 1.0f);
        Gdx.gl.glClear(16384);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.7f, 0.7f, 0.7f, 1.0f);
        this.shapeRenderer.setProjectionMatrix(this.cameraManager.getCamera().combined);
        for (float x = 0.0f; x <= this.cameraManager.getCamera().viewportWidth + 1.0f; x += 0.5f) {
            for (float y = 0.0f; y <= this.cameraManager.getCamera().viewportHeight + 1.0f; y += 0.5f) {
                boolean yEven;
                boolean xEven = (float)Math.round(x) - x < 0.001f;
                boolean bl = yEven = (float)Math.round(y) - y < 0.001f;
                if ((!xEven || yEven) && (xEven || !yEven)) continue;
                this.shapeRenderer.rect(x, y, 0.5f, 0.5f);
            }
        }
        this.shapeRenderer.end();
    }

    @Override
    public void resize(int width, int height) {
        this.ui.onResize(width, height);
        this.cameraManager.onResize(width, height);
        this.cameraManager.getCamera().zoom = 0.8f;
        this.cameraManager.getCamera().update();
        this.debugWindow.onResize(width, height);
        Vector3 newPosition = new Vector3(width, height, 0.0f);
        newPosition.x *= 0.55f;
        newPosition.y *= 0.9f;
        this.cameraManager.getCamera().unproject(newPosition);
        newPosition.x = (float)Math.round(newPosition.x) + 0.5f;
        newPosition.y = (float)Math.round(newPosition.y) + 0.5f;
        this.currentEntity.getLocationComponent().setWorldPosition(new Vector2(newPosition.x, newPosition.y), false);
    }

    @Override
    public void dispose() {
        this.ui.dispose();
        this.batch.dispose();
    }
}

